% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dag.R
\name{rxp_dag_for_ci}
\alias{rxp_dag_for_ci}
\title{Export DAG of Pipeline and Prepare It for Rendering on CI}
\usage{
rxp_dag_for_ci(
  nodes_and_edges = get_nodes_edges(),
  output_file = "_rixpress/dag.dot"
)
}
\arguments{
\item{nodes_and_edges}{List, output of \code{get_nodes_edges()}. Defaults to
calling \code{get_nodes_edges()}.}

\item{output_file}{Character, the path where the DOT file should be saved.
Defaults to \code{"_rixpress/dag.dot"}. The directory will be created if it
doesn't exist.}
}
\value{
Nothing, writes the DOT file to the specified \code{output_file}.
}
\description{
This function generates a DOT file representation of the
pipeline DAG, suitable for visualization, potentially on CI platforms. It
is called by \code{rxp_ga()}.
}
\examples{
\dontrun{
  # Generate the default _rixpress/dag.dot
  rxp_dag_for_ci()

}
}
\seealso{
Other ci utilities: 
\code{\link{rxp_ga}()},
\code{\link{rxp_write_dag}()}
}
\concept{ci utilities}
