% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{predict_rinet_2d}
\alias{predict_rinet_2d}
\title{Predict statistics of the underlying reference distribution from 2D mixture distributions using RINet}
\usage{
predict_rinet_2d(
  data,
  feature_grid_range = c(-4, 4),
  feature_grid_nbins = 100,
  verbose = 0,
  log_scale = TRUE,
  percentiles = c(0.025, 0.975),
  n_bootstrap = 0,
  confidence_level = 0.95
)
}
\arguments{
\item{data}{A matrix or list of matrices. Each sample should be a matrix
with 2 columns representing observations from a 2D mixture distribution.}

\item{feature_grid_range}{Numeric vector of length 2 specifying the range
for histogram binning. Default is c(-4, 4).}

\item{feature_grid_nbins}{Integer specifying the number of histogram bins.
Default is 100.}

\item{verbose}{Integer controlling verbosity (0 = silent). Default is 0.}

\item{log_scale}{Logical indicating whether to log-transform the data before
prediction. If TRUE (default), returns log-scale statistics and calculates
reference intervals in the original scale. Default is TRUE.}

\item{percentiles}{Numeric vector of length 2 specifying the lower and upper
percentiles for the reference interval. Default is c(0.025, 0.975).}

\item{n_bootstrap}{Integer specifying the number of bootstrap resamples for
confidence intervals. Default is 0 (no bootstrap). When > 0, confidence
intervals are computed for all predicted statistics.}

\item{confidence_level}{Numeric specifying the confidence level for bootstrap
intervals. Default is 0.95.}
}
\value{
A list of predictions. Each element contains:
  \item{mean}{Predicted means (vector of length 2, log-scale if log_scale=TRUE)}
  \item{std}{Predicted standard deviations (vector of length 2, log-scale if log_scale=TRUE)}
  \item{covariance}{Predicted covariance matrix (2x2 matrix)}
  \item{correlation}{Predicted correlation coefficient (scalar)}
  \item{reference_fraction}{Predicted reference component fraction}
  \item{reference_interval}{Reference region ellipse vertices (100x2 matrix) in original scale (if log_scale=TRUE)}
  \item{log_scale}{Logical indicating whether log-scaling was used}
  \item{bootstrap_ci}{List of bootstrap confidence intervals (if n_bootstrap > 0):
    mean_ci (2x2 matrix), std_ci (2x2 matrix), correlation_ci, reference_fraction_ci}
}
\description{
Takes one or more 2D samples and predicts the underlying reference
population statistics (means, stds, correlation, reference fraction)
from a mixture of healthy and pathological measurements.
}
\examples{
\dontrun{
  # Single 2D sample (using positive data for log-scale)
  sample1 <- exp(matrix(rnorm(2000, mean = 2, sd = 0.3), ncol = 2))
  result <- predict_rinet_2d(sample1)
  print(result[[1]]$mean)
  print(result[[1]]$covariance)

  # Multiple samples
  samples <- list(exp(matrix(rnorm(2000, mean = 2, sd = 0.3), ncol = 2)),
                  exp(matrix(rnorm(2000, mean = 2, sd = 0.3), ncol = 2)))
  results <- predict_rinet_2d(samples)
}
}
