% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_io.R
\name{write_connectomes_to_parquet}
\alias{write_connectomes_to_parquet}
\title{Write Connectomes to Parquet Files}
\usage{
write_connectomes_to_parquet(
  connectomes,
  output_dir,
  file_pattern = "matrix_\%04d.parquet",
  subject_ids = NULL,
  provenance = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{connectomes}{A list of dppMatrix objects representing SPD matrices}

\item{output_dir}{Path to output directory (will be created if it doesn't exist)}

\item{file_pattern}{File naming pattern with \%d placeholder for index (default: "matrix_\%04d.parquet")}

\item{subject_ids}{Optional vector of subject/sample identifiers (default: NULL)}

\item{provenance}{Optional list containing data provenance information (default: NULL)}

\item{overwrite}{If TRUE, overwrites existing directory (default: FALSE)}
}
\value{
Invisibly returns the path to the output directory
}
\description{
Exports a list of SPD matrices (connectomes) to individual Parquet files
with accompanying metadata.
}
\details{
Creates a directory structure:
\itemize{
\item Individual Parquet files (one per matrix)
\item metadata.json with dimensions, file pattern, and optional metadata
}

The metadata.json file contains:
\itemize{
\item n_matrices: Number of matrices
\item matrix_dim: Dimension p (matrices are p x p)
\item file_pattern: Naming pattern for Parquet files
\item subject_ids: Optional subject identifiers
\item provenance: Optional provenance information
}
}
\examples{
\dontrun{
# Create sample data
mats <- replicate(10, Matrix::pack(Matrix::Matrix(diag(5), sparse = FALSE)), simplify = FALSE)

# Write to Parquet
write_connectomes_to_parquet(
  mats,
  output_dir = "my_connectomes",
  subject_ids = paste0("subj_", 1:10),
  provenance = list(study = "Example Study", date = Sys.Date())
)
}

}
