% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmat.R
\name{removeColumnsByFunc}
\alias{removeColumnsByFunc}
\alias{removeRowsByFunc}
\title{Remove rows or column by function}
\usage{
removeColumnsByFunc(matrix, removeFunc)

removeRowsByFunc(matrix, removeFunc)
}
\arguments{
\item{matrix}{A matrix}

\item{removeFunc}{A function which should return boolean results}
}
\value{
A matrix with rows or columns whose return value of \code{removeFunc}
is \code{TRUE}
}
\description{
Remove rows or column by function
}
\examples{
myMat <- matrix(c(1, 3 ,5, 4, 5, 6, 7, 9, 11), byrow=FALSE, nrow=3)
removeColumnsByFunc(myMat, removeFunc=function(x) any(x \%\% 2 == 0))
removeRowsByFunc(myMat, removeFunc=function(x) any(x \%\% 2 == 0))
}
