% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipse.R
\name{confEllipse}
\alias{confEllipse}
\title{Plot confidence ellipse based on two-dimenstional data}
\usage{
confEllipse(x, y = NULL, conf = 0.95, ...)
}
\arguments{
\item{x}{either a matrix of two columns, or a numeric vector}

\item{y}{either a numeric vector of the same length as \code{x}, or NULL}

\item{conf}{Confidence interval of the ellipse}

\item{...}{Parameters passed to \code{ellipse}}
}
\value{
Invisible coordinates of points on the ellipse
}
\description{
Plot confidence ellipse based on two-dimenstional data
}
\examples{


if(interactive()) {
  testX <- rnorm(100, mean=1, sd=2)
  testY <- rnorm(100, mean=2, sd=3)
  plot(testX, testY, pch=16, xlim=c(-5,7), ylim=c(-7,11))
  confEllipse(testX, testY, col="red", lwd=1)
  confEllipse(testX, testY, conf=0.99, col="red", lwd=2)
  confEllipse(testX, testY, conf=0.9, col="red", lwd=0.5)
}

if(interactive() & require("MASS")) {
  testMVR <- mvrnorm(n=100, mu=c(2,3), Sigma=matrix(c(1, 0.65, 0.65, 1), nrow=2))
  plot(testMVR, pch=16, xlim=c(-2,6), ylim=c(0,6))
  confEllipse(testMVR, col="orange")
  confEllipse(testMVR, conf=0.99, col="red")
  confEllipse(testMVR, conf=0.9, col="lightblue")
}


}
