% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gct.R
\name{gctMatrix2longdf}
\alias{gctMatrix2longdf}
\title{Convert a GctMatrix into a long data frame}
\usage{
gctMatrix2longdf(gctMatrix)
}
\arguments{
\item{gctMatrix}{A GctMatrix object}
}
\value{
A \code{data.frame} with four columns: \code{feature}, \code{desc}, \code{sample}, and \code{value}
}
\description{
Convert a GctMatrix into a long data frame
}
\examples{
idir <- system.file("extdata", package="ribiosIO")
sample.gct.file <- file.path(idir, "test.gct")
test.mat <- read_gct_matrix(sample.gct.file, keep.desc=TRUE)
test.long <- gctMatrix2longdf(test.mat)
}
