% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argparse.R
\name{argGet}
\alias{argGet}
\title{Parse an argument}
\usage{
argGet(opt, default = NULL, choices = NULL)
}
\arguments{
\item{opt}{name of the argument to be parsed}

\item{default}{default values to be returned if the argument is not provided}

\item{choices}{a character vector of accepted values; if a string outside the vector is provided, the function will stop and print error message}
}
\value{
A character string representing the value of the argument
}
\description{
Get the value of an named argument
}
\details{
The parsing is performed at C-level. It is an abbreiviation of argGetPos(opt, ind=1, default=NULL, choices=NULL)
}
\examples{
\donttest{argGet("infile")}

}
\seealso{
\code{\link{argParse}}, \code{\link{argGetPos}}, and \code{\link{argPresent}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
