% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_test.R
\name{get_test}
\alias{get_test}
\title{Get status and meta data of a specific test}
\usage{
get_test(test_id, api_key, wait_for_completion = TRUE)
}
\arguments{
\item{test_id}{ID of a GTmetrix test. (string)}

\item{api_key}{An active GTmetrix API key. (string)}

\item{wait_for_completion}{Whether the function should wait for the
completion of the test. If TRUE (default), the report associated with
the test ID will be requested in roughly 3 second intervals and returned,
when successful. If FALSE, the meta data of the test
will be returned. (TRUE, FALSE)}
}
\value{
A data.frame object that contains either the test meta data or the
GTmetrix report (if it's already completed)
}
\description{
Get the status and meta data of a specific GTmetrix test.
Returns the associated report instead, if the report is already completed.
}
\examples{
\dontrun{output_table <- get_test(
                           test_id = "TEST_ID",
                           api_key = "API_KEY"
                         )}
}
