% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support.R
\name{write_exercise_csv}
\alias{write_exercise_csv}
\title{Write an exercise csv file}
\usage{
write_exercise_csv(df, file, sep = ",")
}
\arguments{
\item{df}{A data frame.}

\item{file}{A string, name of a text file.}

\item{sep}{Column separator character.}
}
\value{
A string.
}
\description{
Writes an exercise data frame in a csv file of exercises.
}
\examples{

file <- system.file("extdata/example.csv", package = "rexer")
df <- read_exercise_csv(file)
df <- set_pending_answers(df)

write_exercise_csv(df, file = tempfile(fileext = '.csv'))

}
\seealso{
Other support functions: 
\code{\link{create_exercise_csv}()},
\code{\link{create_exercise_data_frame}()},
\code{\link{create_exercise_excel}()},
\code{\link{read_exercise_csv}()},
\code{\link{read_exercise_excel}()},
\code{\link{set_pending_answers}()},
\code{\link{vector_to_string}()}
}
\concept{support functions}
