% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exercises.R
\name{define_an_exercise}
\alias{define_an_exercise}
\alias{define_an_exercise.exam}
\title{Define an exercise}
\usage{
define_an_exercise(ex, type, statement, image, image_alt, answer, ...)

\method{define_an_exercise}{exam}(
  ex,
  type = "",
  statement = "",
  image = "",
  image_alt = "",
  answer = "",
  ...
)
}
\arguments{
\item{ex}{An `exam` object.}

\item{type}{A character, 'p' indicates whether the exercise starts on a new page.}

\item{statement}{A string, statement of the exercise.}

\item{image}{A string, optional, image file to include in the exercise.}

\item{image_alt}{A string, description of the image to include in the exercise.}

\item{answer}{A string, correct answer to the exercise.}

\item{...}{A string, options for the gaps in the exercise.}
}
\value{
An `exam`.
}
\description{
Defines an exercise with random components.
}
\details{
If an image is included in the exercise, text in the `image_alt` field associated
with it must also be included.

Following the answer, options can be defined to fill in the gaps that have been
specified in the exercise.

Both the answer and the options are formed by a vector of strings, from which
one is chosen to formulate the exercise and select the answer. To represent a
vector of strings in a cell, the function `vector_to_string()` is used, which
includes a separator ("<|>") between the vector elements to generate a string.
}
\examples{

rmd <- system.file("extdata/template01.Rmd", package = "rexer")
ex <- exam(
  rmd = rmd,
  examinees = NULL,
  instances_num = 10,
  random = TRUE,
  reorder_exercises = TRUE,
  select_n_exercises = NULL
) |>
  define_an_exercise(
    type = 'p',
    statement = 'What is the three-letter country code (ISO 3166-1 alpha-3) for
    the country represented in the figure below?',
    image = paste0(system.file("extdata/figures", package = "rexer"), "/", '[[1]]'),
    image_alt = 'Country outline.',
    answer = c('ESP', 'CHL', 'NZL', 'ITA'),
    c('spain.png', 'chile.png', 'new_zealand.png', 'italy.png')
  )

}
\seealso{
\code{\link{exam}}, \code{\link{vector_to_string}}

Other exercise definition: 
\code{\link{define_exercises}()},
\code{\link{define_exercises_from_csv}()},
\code{\link{define_exercises_from_excel}()}
}
\concept{exercise definition}
