% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dp_multi.R
\name{dp_multi}
\alias{dp_multi}
\title{Dynamic Programming with multiple objectives (supply, flood control, amenity)}
\usage{
dp_multi(Q, capacity, target, surface_area, max_depth, evap, R_max = 2 *
  target, spill_targ = 0.95, vol_targ = 0.75, weights = c(0.7, 0.2, 0.1),
  loss_exp = c(2, 2, 2), S_disc = 1000, R_disc = 10, S_initial = 1,
  plot = TRUE, rep_rrv = FALSE)
}
\arguments{
\item{Q}{vector or time series object. Net inflow totals to the reservoir. Recommended units: Mm^3 (Million cubic meters).}

\item{capacity}{numerical. The reservoir storage capacity (must be the same volumetric unit as Q and the target release).}

\item{target}{numerical. The target release constant. Recommended units: Mm^3 (Million cubic meters).}

\item{surface_area}{numerical. The reservoir water surface area at maximum capacity. Recommended units: km^2 (square kilometers).}

\item{max_depth}{numerical. The maximum water depth of the reservoir at maximum capacity. If omitted, the depth-storage-area relationship will be estimated from surface area and capacity only. Recommended units: meters.}

\item{evap}{vector or time series object of length Q, or a numerical constant.  Evaporation from losses from reservoir surface. Varies with level if depth and surface_area parameters are specified. Recommended units: meters, or kg/m2 * 10 ^ -3.}

\item{R_max}{numerical. The maximum controlled release, in the same units as target.}

\item{spill_targ}{numerical. The quantile of the inflow time series used to standardise the "minimise spill" objective.}

\item{vol_targ}{numerical. The target storage volume constant (as proportion of capacity).}

\item{weights}{vector of length 3 indicating weighting to be applied to release, spill and water level objectives respectively.}

\item{loss_exp}{vector of length 3 indicating the exponents on release, spill and water level deviations from target. Default exponents are c(2,2,2).}

\item{S_disc}{integer. Storage discretization--the number of equally-sized storage states. Default = 1000.}

\item{R_disc}{integer. Release discretization. Default = 10 divisions.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{rep_rrv}{logical. If TRUE then reliability, resilience and vulnerability metrics are computed and returned.}
}
\value{
Returns reservoir simulation output (storage, release, spill), total penalty cost associated with the objective function, and, if requested, the reliability, resilience and vulnerability of the system.
}
\description{
Determines the optimal sequence of releases from the reservoir to minimise a penalty cost function based on water supply, spill, and water level. For water supply: Cost[t] = ((target - release[t]) / target) ^ loss_exp[1]). For flood control: Cost[t] = (Spill[t] / quantile(Q, spill_targ)) ^ loss_exp[2]. For amenity: Cost[t] = abs(((storage[t] - (vol_targ * capacity)) / (vol_targ * capacity))) ^ loss_exp[3].
}
\examples{
layout(1:3)
dp_multi(resX$Q_Mm3, cap = resX$cap_Mm3, target = 0.2 * mean(resX$Q_Mm3), S_disc = 100)
}
\seealso{
\code{\link{sdp_multi}} for Stochastic Dynamic Programming
}

