% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valReplacement.R
\name{sReplace}
\alias{sReplace}
\title{Helper function for value replacement}
\usage{
sReplace(x, y0, uv)
}
\arguments{
\item{x, y0}{Data.tables}

\item{uv}{Character vector or list of same length as x, containing unique names of
involved columns in data.}
}
\value{
A named list containing updated involved columns in x, count of multiple replacements
of duplicated values (if requested), count of multiple replacements of missing values
(if requested).
}
\description{
The function is not intended for direct use. Once called by \link[=replaceVals]{replaceVals}
it firstly checks for index presence in lookup. Upon the result of this check, the
function moves along the branches of a decision tree (see Details).
}
\details{
The function starts by checking the presence of a User-made index in lookup.
\subsection{If the index is found absent}{

The function calls the helper \link[=whichDups]{whichDups} to find the duplicated values in data. Also, looks for missing
values set for \emph{multiple} replacements and for eventual splits on missing data. In case of mixed \emph{simple/multiple}
requests the function splits lookup into maximum 3 subsets: one for \emph{simple} replacements, for which it creates an
internal index, one for \emph{multiple replacements} of duplicated values for which it creates an internal index, and one
for \emph{multiple replacements} of missing values for which an internal index is not necessary.
\subsection{Index for multiple replacements of duplicated values}{

The internal index contains row numbers corresponding to all the elements of distinct subsets of duplicated values
found within each involved data column and loops the function \code{data.table::set()} to perform replacements on these
columns.
}

\subsection{No Index for multiple replacements of missing values}{

As mentioned above, no index is created for multiple replacements of missing values as there is only one generic value
per data column. The missing values data subset is then \emph{reshaped}, and the columns are \emph{coalesced} (see \code{data.table}
Manual) with corresponding data columns, for each generic value entered in lookup.
}

\subsection{Index For Unique Values}{

As stated above, simple replacements of unique values without User-made index are possible. Once the internal index
created, the subset is \emph{reshaped}, \emph{joined} with the data on index and the corresponding columns are \emph{coalesced}.
}

}

\subsection{If the index is found present}{

The function subsets the lookup using the special index values \strong{0} and/or \strong{NA} (or empty). At maximum, 3 subsets
of lookup are formed as above. The replacement process is similar with the process used for absent index with the
difference that simple replacements already have User-made index.
}

\subsection{Value replacement}{

Following the decision tree described above, the function calls utility's helpers and functions imported from the
\strong{data.table} package to process all lookup requests, in one single run.
}
}
\seealso{
\link[data.table:dcast.data.table]{dcast}, \link[data.table:coalesce]{fcoalesce},
\link[data.table:merge]{merge}, \link[data.table:assign]{set}
}
