% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bReplace.R
\name{bReplace}
\alias{bReplace}
\title{Batch-file value replacement}
\usage{
bReplace(dir, x, save = TRUE, msgs = FALSE)
}
\arguments{
\item{dir}{Quoted character of length = 1 describing the path to the directory containing the data and associated
lookup files, with either forward or double backward slash and no end slash (e.g. \emph{"C:/path/to/directory"}).}

\item{x}{List of character vectors each of length 2 containing full names of the data file and the associated
lookup file, as described in \link[=replaceVals]{replaceVals}.}

\item{save}{Logical, default TRUE: save results to directory; FALSE: display only.}

\item{msgs}{Logical, default FALSE: suppress messages. TRUE: print a named list containing messages specific to each run.}
}
\value{
A named list displaying updated data and multiple replacement count tables. Also, updated csv files which are saved
to \emph{dir}.
}
\description{
User-intended function to process a list of pairs of data files and associated lookup files listed in this order.
}
\section{Note}{
 In examples, please leave argument \emph{save} to FALSE. Otherwise, copy all content of folder "extdata"
found in the installed package root into a directory on your machine. Use the absolute path to this directory as
\emph{dir} argument.
}

\examples{

if (interactive()) {
# A list of data/lookup names:
fs = list(c('data.csv', 'lookup.csv')
        , c("data_unique.csv", "lookup_unique.csv")
        , c('data_id.csv', 'lookupNA.csv')
        , c('data_id.csv', 'lookupDUP.csv')
        , c('chile.csv', 'chile_nadup.csv')
        , c('data_id.csv', 'lookup_id.csv')
        , c('data_id.csv', 'lookup_idsimple.csv')
        , c('chile.csv', 'chile_id.csv')

      )
 ##Not run:
 dir = system.file("extdata", package = "replacer")
 bReplace(dir, fs, save = FALSE, msgs = TRUE)
 }

}
\seealso{
\link[=replaceVals]{replaceVals}
}
