% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load}
\alias{load}
\title{Load a project}
\usage{
load(project = NULL, quiet = FALSE, profile = NULL, ...)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{quiet}{Boolean; be quiet during load?}

\item{profile}{The profile to be activated. See
\code{vignette("profiles", package = "renv")} for more information.
When \code{NULL} (the default), the profile is not changed. Use
\code{profile = "default"} to revert to the default \code{renv} profile.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
\code{renv::load()} sets the library paths to use a project-local library,
sets up the system library \link{sandbox}, if needed, and creates shims
for \code{install.packages()}, \code{update.packages()}, and \code{remove.packages()}.

You should not generally need to call \code{renv::load()} yourself, as it's
called automatically by the project auto-loader created by \code{\link[=init]{init()}}/
\code{\link[=activate]{activate()}}. However, if needed, you can use \code{renv::load("<project>")}
to explicitly load an renv project located at a particular path.
}
\section{Shims}{
To help you take advantage of the package cache, renv places a couple of
shims on the search path:
\itemize{
\item \code{install.packages()} instead calls \code{renv::install()}.
\item \code{remove.packages()} instead calls \code{renv::remove()}.
\item \code{update.packages()} instead calls \code{renv::update()}.
}

This allows you to keep using your existing muscle memory for installing,
updating, and remove packages, while taking advantage of renv features
like the package cache.

If you'd like to bypass these shims within an \R session, you can explicitly
call the version of these functions from the utils package, e.g. with
\verb{utils::install.packages(<...>)}.

If you'd prefer not to use the renv shims at all, they can be disabled by
setting the R option \code{options(renv.config.shims.enabled = FALSE)} or by
setting the environment variable \code{RENV_CONFIG_SHIMS_ENABLED = FALSE}. See
\code{?config} for more details.
}

\examples{
\dontrun{

# load a project -- note that this is normally done automatically
# by the project's auto-loader, but calling this explicitly to
# load a particular project may be useful in some circumstances
renv::load()

}
}
