% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_get_federated_instances}
\alias{lemmy_get_federated_instances}
\title{Fetch federated instances.}
\usage{
lemmy_get_federated_instances(
  auth = NULL,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{auth}{(Optional) A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 1:
\preformatted{<list>
`-federated_instances: <list>
  |-linked: <list>
  | `-[Each element]: <list>
  |   |-id: A numeric value
  |   |-domain: A character value
  |   |-published: A character value
  |   |-updated: (Optional) A character value
  |   |-software: (Optional) A character value
  |   `-version: (Optional) A character value
  |-allowed: <list>
  | `-[Each element]: <list>
  |   |-id: A numeric value
  |   |-domain: A character value
  |   |-published: A character value
  |   |-updated: (Optional) A character value
  |   |-software: (Optional) A character value
  |   `-version: (Optional) A character value
  `-blocked: <list>
    `-[Each element]: <list>
      |-id: A numeric value
      |-domain: A character value
      |-published: A character value
      |-updated: (Optional) A character value
      |-software: (Optional) A character value
      `-version: (Optional) A character value
}
}
\description{
\code{HTTP.Get /federated_instances}
}
\examples{
\dontshow{if (remmy:::is_lemmy_world()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
instances <- lemmy_get_federated_instances()

length(instances$federated_instances$linked)

some_instance <- instances$federated_instances$linked[[732]]

some_instance$domain

some_instance$published
\dontshow{\}) # examplesIf}
}
