% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myroc.R
\name{myroc}
\alias{myroc}
\title{Compute ROC and other performance measures for binomial model}
\usage{
myroc(ytest, rit, N = 100)
}
\arguments{
\item{ytest}{True test outcome: vector of 0s and 1s.}

\item{rit}{Predictions for the true outcome. Should be vector of continuous
variables between 0 and 1.}

\item{N}{Number of breakpoints where we evaluate the performance measures.
Default is 100.}
}
\value{
A list of performance measures and intermediate computations.
\item{sens}{Vector of sensitivity values.}
\item{spec}{Vector of specificity values.}
\item{ppv}{Vector of PPV values.}
\item{npv}{Vector of NPV values}
\item{area}{Area under ROC curve (AUC).}
\item{se}{Standard error for AUC.}
\item{cutp}{Cut points at which the performance measures were computed.}
\item{cutp.max}{Cut point which maximizes (sens + spec) / 2.}
}
\description{
Given a vector of true outcomes and a vector of predictions, returns a list
containing performance measures.
}
\details{
We currently evaluate the performance measures at 100 quantiles of the
predicted values; this can be adjusted via the \code{N} option.
}
