% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{groups}
\alias{groups}
\title{Extract Named Groups from a String Using a Regex Pattern}
\usage{
groups(pattern, s, ignore.case = FALSE)
}
\arguments{
\item{pattern}{A character string containing the regex pattern with named groups.}

\item{s}{A character string where the pattern will be searched.}

\item{ignore.case}{Logical. If TRUE, the pattern matching is case-insensitive. Default is FALSE.}
}
\value{
A named list where names are the named groups and values are the extracted strings.
If no matches are found, an empty list is returned.
}
\description{
This function extracts named groups from a given string using the specified regex pattern.
Named groups in the pattern are denoted using \verb{(?P<group_name>...)} syntax.
}
\examples{
pattern <- "(?P<name>\\\\w+) is (?P<age>\\\\d+)"
s <- "Jane is 25"
groups(pattern, s)
# $name
# [1] "Jane"
# $age
# [1] "25"

}
