% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_rga3h.R
\name{rga3h}
\alias{rga3h}
\title{reverse graphical approach for three hypotheses}
\usage{
rga3h(w, G, p, alpha)
}
\arguments{
\item{w}{a vector of initial weights}

\item{G}{a matrix of initial transaction weights}

\item{p}{a vector of p-values}

\item{alpha}{a number of significance level}
}
\value{
a logical vector indicating whether the hypothesis is rejected: TRUE = rejected, FALSE = accepted
}
\description{
reverse graphical approach for three hypotheses
}
\examples{
w <- c(0.3,0.5,0.2)
G <- matrix(c(0,1/3,2/3, 1/2,0,1/2, 1/5,4/5,0),nrow=3,byrow=TRUE)
p <- c(0.012, 0.051, 0.021)
p <- c(0.012, 0.051, 0.019)
alpha <- 0.05
rga3h(w=w,G=G,p=p, alpha=alpha)
}
\references{
Gou, J. (2020). Reverse graphical approaches for multiple test procedures. Technical Report.
}
\author{
Jiangtao Gou
}
