% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regioncode.R
\name{regioncode}
\alias{regioncode}
\title{\code{regioncode} is developed to conquer the difficulties to convert various region names and administration division codes of Chinese regions. In the current version, \code{regioncode} enables seamlessly converting Chinese regions' formal names, common-used names, and geocodes between each other at the prefectural level from 1986 to 2019.}
\usage{
regioncode(
  data_input,
  year_from = 1999,
  year_to = 2015,
  convert_to = "code",
  incomplete_name = FALSE,
  zhixiashi = FALSE,
  to_dialect = "none",
  to_pinyin = FALSE,
  province = FALSE
)
}
\arguments{
\item{data_input}{A character vector for names or a six-digit integer vector for division codes to convert.}

\item{year_from}{A integer to define the year of the input. The default value is 1999.}

\item{year_to}{A integer to define the year to convert. The default value is 2015.}

\item{convert_to}{A character indicating the converting methods. At the prefectural level, valid methods include converting between codes in different years, from codes to city ranks, from codes to region names, from region names to city ranks, from region names to division codes, from region names or division codes to sociopolitical area names, and between names in different years. The current version automatically detect the type of the input. Users only need to choose the output to be codes (\code{code}), names (\code{name}) , area (\code{area}) or city ranks (\code{rank}). The default option is \code{code}.
When \code{province} is TRUE, one can also choose \code{abbre}, \code{abbreTocode}, \code{abbreToname}, and \code{abbreToarea} to convert between names/codes and abbreviations of provinces.}

\item{incomplete_name}{A logic strong to indicate if the input has incomplete names (not nickname). See more in "Details".}

\item{zhixiashi}{A logic string to indicate whether treating division codes and names of municipality directly under the central government (Only makes a difference for prefectural-level conversion). The default value is FALSE.}

\item{to_dialect}{A character indicating the language transformation. At the prefectural level, valid transformation include \code{dia_group},\code{dia_sub_group}. At the province level, valid transformation is \code{dia_super}. The default value is "none".
When \code{province} is TRUE, one can also choose \code{dia_super} to get the language zone of provinces.}

\item{to_pinyin}{A logic string to indicate whether the output is in pinyin spelling instead of Chinese characters. The default is FALSE.}

\item{province}{A logic string to indicate the level of converting. The default is FALSE.}
}
\value{
The function returns a character or numeric vector depending on what method is specified.
}
\description{
\code{regioncode} is developed to conquer the difficulties to convert various region names and administration division codes of Chinese regions. In the current version, \code{regioncode} enables seamlessly converting Chinese regions' formal names, common-used names, and geocodes between each other at the prefectural level from 1986 to 2019.
}
\details{
In many national and regional data in China studies, the source applies incomplete names instead of the official, full name of a given region. A typical case is that "Xinjiang" is used much more often than "Xinjiang Weiwuer Zizhiqu" (the Xinjiang Uygur Autonomous Region) for the name of the province. In other cases the "Shi" (City) is often omitted to refer to a prefectural city. \code{regioncode} accounts this issue by offering the argument \code{incomplete_name}.
\itemize{
\item "none": no short name will be used for either input or output;
\item "from": input data is short names instead of the full, official ones;
\item "to": output results will be short names;
\item "both": both input and output are using short names.
}

The argument makes a difference only when \code{code} or \code{name} are chose in \code{convert_to}.
Users can use this argument together with \code{name} to convert between names and incomplete names.
}
\examples{
\dontrun{
# The example can be run well but CRAN does not like Chinese characters, so here just "dontrun" it.

library(regioncode)

regioncode(
  data_input = corruption$prefecture_id,
  year_from = 2016,
  year_to = 2017
)
}

}
