% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.r
\name{d_gaussian_itemblock_proxy}
\alias{d_gaussian_itemblock_proxy}
\title{Partial derivatives for continuous items using proxy data.}
\usage{
d_gaussian_itemblock_proxy(
  p_item,
  prox_data,
  responses_item,
  pred_data,
  samp_size,
  num_items,
  num_quad,
  num_predictors
)
}
\arguments{
\item{p_item}{Vector of item parameters.}

\item{prox_data}{Vector of observed proxy scores.}

\item{responses_item}{Vector of item responses.}

\item{pred_data}{Matrix or dataframe of DIF and/or impact predictors.}

\item{samp_size}{Sample size in dataset.}

\item{num_items}{Number of items in dataset.}

\item{num_quad}{Number of quadrature points used for approximating the
latent variable.}

\item{num_predictors}{Number of predictors in dataset.}
}
\value{
a \code{"list"} of first and second partial derivatives for mean value of Gaussian item
likelihood (to use with coordinate descent and univariate Newton-Raphson)
}
\description{
Partial derivatives for continuous items using proxy data.
}
\keyword{internal}
