## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, fig.width=7, fig.height=4)

## -----------------------------------------------------------------------------
library(regDIF)
head(ida)

## ----results='hide'-----------------------------------------------------------
item.data <- regDIF::ida[,1:6]
pred.data <- regDIF::ida[,7:9]
fit <- regDIF(item.data, pred.data, tau = 2)

## -----------------------------------------------------------------------------
summary(fit)

## -----------------------------------------------------------------------------
coef(fit)

## ----results='hide'-----------------------------------------------------------
fit2 <- regDIF(item.data, pred.data, num.tau = 10, control = list(tol = 1e-3))

## -----------------------------------------------------------------------------
fit2

## -----------------------------------------------------------------------------
summary(fit2)

## -----------------------------------------------------------------------------
plot(fit2)

## -----------------------------------------------------------------------------
fit2$impact

## -----------------------------------------------------------------------------
lapply(fit2$eap, head)

## ----results='hide'-----------------------------------------------------------
fit3 <- regDIF(item.data, pred.data, prox.data = rowSums(item.data), num.tau = 20)

## -----------------------------------------------------------------------------
summary(fit3)

## ----results='hide'-----------------------------------------------------------
fit_net <- regDIF(item.data, pred.data, prox.data = rowSums(item.data), num.tau = 20, alpha = .5)

## -----------------------------------------------------------------------------
summary(fit_net)

## ----results='hide'-----------------------------------------------------------
fit_grp_mcp <- regDIF(item.data, pred.data, prox.data = rowSums(item.data), num.tau = 20, pen.type = "grp.mcp")

## -----------------------------------------------------------------------------
summary(fit_grp_mcp)

## ----echo=F-------------------------------------------------------------------
citation("regDIF")

