% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_decl}
\alias{part_decl}
\title{Calculate Declination}
\usage{
part_decl(plans, shp, dvote, rvote, normalize = TRUE, adjust = TRUE)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{dvote}{Unqouted name of column in \code{shp} with total population.}

\item{rvote}{Unqouted name of column in \code{shp} with group population.}

\item{normalize}{Default is TRUE Translate score to an angle?}

\item{adjust}{Default is TRUE. Applies a correction to increase cross-size comparison.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Declination
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_decl(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_decl(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Gregory S. Warrington. 2018. "Quantifying Gerrymandering Using the Vote Distribution."
Election Law Journal: Rules, Politics, and Policy. Pp. 39-57.http://doi.org/10.1089/elj.2017.0447
}
\concept{partisan}
