% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTM.R
\name{RTM}
\alias{RTM}
\alias{dRTM}
\alias{pRTM}
\alias{rRTM}
\title{Rational Threshold Model}
\usage{
dRTM(rt, resp, phi, x_res = "default", t_res = "default")

pRTM(rt, resp, phi, x_res = "default", t_res = "default")

rRTM(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Stimulus strength (\eqn{\mu}). Strength of the stimulus and used to set the drift
rate. For changing threshold models \eqn{v(x,t) = \mu}.
\item Noise scale (\eqn{\sigma}). Model noise scale parameter.
\item Initial decision threshold location (\eqn{b_0}). Sets the location of each decision
threshold at time \eqn{t = 0}.
\item Amount of decision threshold collapse (\eqn{\kappa}).
\item Semi-saturation constant (\eqn{t_{0.5}}). The semi-saturation constant is the value of
time at which the boundaries have collapsed by half \eqn{\kappa}.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
SDDM with thresholds that change with time. Thresholds are rational functions of the
form \deqn{b_u(t) = -b_l(t) =  0.5*b_0*(1 - \kappa*t/(t + t_{0.5})).}
}
\examples{
# Probability density function
dRTM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.5, 0.5, 0.0, 0.0, 1.0))

# Cumulative distribution function
pRTM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.5, 0.5, 0.0, 0.0, 1.0))

# Random sampling
rRTM(n = 100, phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.5, 0.5, 0.0, 0.0, 1.0))
}
\references{
Churchland, A. K., Kiani, R., & Shadlen, M. N. (2008). Decision-making with multiple
alternatives. \emph{Nature Neuroscience, 11}(6), 693-702.

Hanks, T. D., Mazurek, M. E., Kiani, R., Hopp, E., & Shadlen, M. N. (2011). Elapsed
Decision Time Affects the Weighting of Prior Probability in a Perceptual Decision
Task. \emph{The Journal of Neuroscience, 31}(17), 6339-6352.

Voskuilen, C., Ratcliff, R., & Smith, P. L. (2016). Comparing fixed and collapsing boundary
versions of the diffusion model. \emph{Journal of Mathematical Psychology, 73}, 59-79.
}
\author{
Raphael Hartmann & Matthew Murrow
}
