% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{group_merge_sort}
\alias{group_merge_sort}
\title{Hide rows containing duplicate values on sort. Must be placed within reactable::colDef(style).
Credit to Greg Lin, creator of {reactable} for writing the JS function.}
\usage{
group_merge_sort(col_name = NULL)
}
\arguments{
\item{col_name}{Name of the column.}
}
\value{
a function that hides duplicate values on sort in a reactable table.
}
\description{
Hide rows containing duplicate values on sort. Must be placed within reactable::colDef(style).
Credit to Greg Lin, creator of {reactable} for writing the JS function.
}
\examples{
data <- MASS::Cars93[1:20, c("Manufacturer", "Model", "Type", "MPG.city")]

## Merge unique groups in a column:
reactable(data,
pagination = FALSE,
columns = list(Manufacturer = colDef(
style = group_merge_sort("Manufacturer")
))
)

## Works with columns containing numeric data as well:
reactable(data,
pagination = FALSE,
columns = list(MPG.city = colDef(
style = group_merge_sort("MPG.city")
))
)
}
