% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{add_title}
\alias{add_title}
\title{Add a title above a reactable table}
\usage{
add_title(
  table = NULL,
  title = NULL,
  align = "left",
  font_color = "#000",
  font_size = 32,
  font_style = "normal",
  font_weight = "bold",
  text_decoration = NULL,
  text_transform = NULL,
  letter_spacing = NULL,
  word_spacing = NULL,
  text_shadow = NULL,
  background_color = "#FFFFFF",
  margin = NULL
)
}
\arguments{
\item{table}{A reactable table.}

\item{title}{A string to be displayed as the title.}

\item{align}{The alignment of the table.
Options are "left", "right", "center".
Default is "left".}

\item{font_color}{Color of the title text.
Default is #000.}

\item{font_size}{Numeric value representing the size of the font of the title (in px).
Default is 32.}

\item{font_style}{Style of the title font.
Options are "normal" or "italic".
Default is "normal".}

\item{font_weight}{The font weight of the title.
Options are "bold" or "normal".
Default is "bold".}

\item{text_decoration}{Add an underline, overline, or line-through title.
Default is NULL.}

\item{text_transform}{Specify how to capitalize the title.
Options are "uppercase", "lowercase", or "capitalize".
Default is NULL.}

\item{letter_spacing}{Numeric value that adjusts the horizontal spacing between letters.
A number above 0 adds more spacing between letters, a number below 0 decreases the spacing.
Default is NULL.}

\item{word_spacing}{Numeric value that adjusts the horizontal spacing between words.
A number above 0 adds more spacing between words, a number below 0 decreases the spacing.
Default is NULL.}

\item{text_shadow}{Apply a shadow around the title.
See <https://developer.mozilla.org/en-US/docs/Web/CSS/text-shadow> for options.
Default is NULL.}

\item{background_color}{Color of the title background.
Default is #FFFFFF.}

\item{margin}{Use margin() to set the margin around the text (top, right, bottom, left).
Default is NULL.}
}
\value{
a function that adds a title above a reactable table.
}
\description{
Use `add_title()` to place a title above a {reactable} or {reactablefmtr} table.
     The title can be aligned to the left, right, or center with the align option.
     The text properties of the title, such as the font size and font style can be customized.
     The background color of the title can also be adjusted as well as the margin around the title.
}
\examples{
\dontrun{
## Create the reactable table and then pipe in the title
table <- reactable(iris[10:29, ])

table \%>\%
  add_title("This is a title")

## Use options to adjust the style and position of the title
table \%>\%
  add_title("This is a title", align = "center", font_color = "red")
}
}
