% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_finturk.R
\name{fetch_finturk}
\alias{fetch_finturk}
\title{Fetch multiple period FinTurk data}
\usage{
fetch_finturk(
  start_year,
  start_month,
  end_year,
  end_month,
  table_no,
  grup_kod = 10001,
  il = 0,
  delay = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{start_year, end_year}{Starting/ending year (YYYY).}

\item{start_month, end_month}{Starting/ending month (3,6,9,12).}

\item{table_no}{Table number to fetch (1-7). No default.
Use \code{\link{list_tables}} with \code{source = "finturk"} to see available options.}

\item{grup_kod}{Group code (10001-10007). Default 10001.
Use \code{\link{list_groups}} with \code{source = "finturk"} to see available options.}

\item{il}{plaka (license plate) number (0-81, 99). Default 0.}

\item{delay}{Delay between requests in seconds. Default 0.5.}

\item{verbose}{Print progress messages. Default TRUE.}
}
\value{
Combined data frame with "fetch_info" attribute.
}
\description{
Fetches FinTurk data for a range of quarters by calling fetch_finturk1 iteratively.
}
\examples{
\donttest{
  # Fetch multiple quarters
  my_data <- fetch_finturk(2024, 3, 2024, 9, table_no = 1)
}

}
\seealso{
\code{\link[=fetch_bddk]{fetch_bddk()}} for monthly BRSA data .
}
