% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fun_approx}
\alias{fun_approx}
\title{Approximation Function for Intensive Calculations}
\usage{
fun_approx(u, u_lb = -100, u_ub = 100, resol = 10000, fun = W_kernel)
}
\arguments{
\item{u}{A vector of values where the function should be evaluated.}

\item{u_lb}{Lower bound for the precomputed range. Defaults to -10.}

\item{u_ub}{Upper bound for the precomputed range. Defaults to 10.}

\item{resol}{The resolution or number of sample points in the precomputed range. Defaults to 1000.}

\item{fun}{A function for which the approximation is computed. Defaults to the \code{W} function.}
}
\value{
A vector of approximated function values corresponding to \code{u}.
}
\description{
This function provides a lookup-based approximation for calculations that are computationally intensive.
Once computed, it stores the results in an environment and uses linear interpolation for new data points
to speed up subsequent computations.
}
\details{
The \code{fun_approx} function works by initially creating a lookup table of function values based on
the range specified by \code{u_lb} and \code{u_ub} and the resolution \code{resol}. This precomputation only happens once
for a given set of parameters (\code{u_lb}, \code{u_ub}, \code{resol}, and \code{fun}). Subsequent calls to \code{fun_approx} with the
same parameters use the lookup table to find the closest precomputed points to the requested \code{u} values
and then return an interpolated result.

Linear interpolation is used between the two closest precomputed points in the lookup table. This
ensures a smooth approximation for values in between sample points.

This function is especially useful for computationally intensive functions where recalculating
function values is expensive or time-consuming. By using a combination of precomputation and
interpolation, \code{fun_approx} provides a balance between accuracy and speed.
}
