% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{create_biasBound_config}
\alias{create_biasBound_config}
\title{Create a configuration object for bias bound estimations}
\usage{
create_biasBound_config(
  X,
  Y = NULL,
  h = NULL,
  h_method = "cv",
  use_fft = TRUE,
  alpha = 0.05,
  resol = 100,
  xi_lb = NULL,
  xi_ub = NULL,
  methods_get_xi = "Schennach",
  kernel.fun = "Schennach2004",
  if_approx_kernel = TRUE,
  kernel.resol = 1000
)
}
\arguments{
\item{X}{A numerical vector of sample data.}

\item{Y}{Optional. A numerical vector of sample data for conditional expectation.}

\item{h}{A scalar bandwidth parameter. If NULL, the bandwidth is automatically selected using the method specified in 'h_method'.}

\item{h_method}{Method for automatic bandwidth selection when h is NULL. Options are "cv" (cross-validation) and "silverman" (Silverman's rule of thumb). Default is "cv".}

\item{use_fft}{Ignored. Maintained for backward compatibility.}

\item{alpha}{Confidence level for intervals.}

\item{resol}{Resolution for the estimation range.}

\item{xi_lb}{Lower bound for the interval of Fourier Transform frequency.}

\item{xi_ub}{Upper bound for the interval of Fourier Transform frequency.}

\item{methods_get_xi}{Method to determine xi interval.}

\item{kernel.fun}{Kernel function to be used. Options include "normal", "epanechnikov", "Schennach2004", and "sinc".}

\item{if_approx_kernel}{Use approximations for the kernel function.}

\item{kernel.resol}{Resolution for kernel approximation.}
}
\value{
A configuration object (list) with all parameters
}
\description{
Create a configuration object for bias bound estimations
}
