% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_offset_polygon.R
\name{generate_offset_polygon}
\alias{generate_offset_polygon}
\title{Generate an offset polygon}
\usage{
generate_offset_polygon(skeleton, offset, progress = FALSE)
}
\arguments{
\item{skeleton}{Default `NULL`. A straight skeleton generated from the `skeletonize` function.}

\item{offset}{Default `NULL`. The offset(s) of the polygon.}

\item{progress}{Default `FALSE`. Whether to display a progress bar.}
}
\value{
A list of data frames, each representing a polygon offset by the specified amount.
}
\description{
This function generates an interior offset polygon from a straight skeleton.
}
\examples{
# Simple polygon example
simple_poly = matrix(c(0,0, 3,0, 3,3, 0,3, 0,0), ncol=2, byrow=TRUE)
skeleton = skeletonize(simple_poly)
offset_polys = generate_offset_polygon(skeleton, c(0.25, 0.5))
print(offset_polys)

# Polygon with hole example
# Outer polygon
vertices = matrix(c(0,0, 7,0, 7,7, 0,7, 0,0), ncol = 2, byrow = TRUE)
# Holes inside the polygon
hole_1 = matrix(c(1,1, 2,1, 2,2, 1,2, 1,1), ncol = 2, byrow = TRUE)[5:1,]
hole_2 = matrix(c(5,5, 6,5, 6,6, 5,6, 5,5), ncol = 2, byrow = TRUE)[5:1,]
skeleton = skeletonize(vertices, holes = list(hole_1, hole_2))
if(run_docs_raybevel()) {
plot_skeleton(skeleton)
}

#Generate three offsets
if(run_docs_raybevel()) {
plot_offset_polygon(generate_offset_polygon(skeleton, c(0.25,0.75,1.5,2)))
}

#Generate many offsets
if(run_docs_raybevel()) {
plot_offset_polygon(generate_offset_polygon(skeleton, seq(0,2.5,by=0.1)+0.05))
}

# Skeletonize and plot an {sf} object
if(run_docs_raybevel()) {
  us_states = spData::us_states
  texas = us_states[us_states$NAME == "Texas",]
  texas_skeleton = skeletonize(texas)
  plot_offset_polygon(generate_offset_polygon(texas_skeleton, seq(0, 2.5, by = 0.1)),
                      border = heat.colors,
                      linewidth = 1)
}
}
