% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math-baseline_power.R
\name{power_baseline}
\alias{power_baseline}
\alias{power_baseline.rave_prepare_power}
\alias{power_baseline.FileArray}
\alias{power_baseline.array}
\title{Calculate power baseline}
\usage{
power_baseline(
  x,
  baseline_windows,
  method = c("percentage", "sqrt_percentage", "decibel", "zscore", "sqrt_zscore"),
  units = c("Trial", "Frequency", "Electrode"),
  ...
)

\method{power_baseline}{rave_prepare_power}(
  x,
  baseline_windows,
  method = c("percentage", "sqrt_percentage", "decibel", "zscore", "sqrt_zscore"),
  units = c("Frequency", "Trial", "Electrode"),
  electrodes,
  ...
)

\method{power_baseline}{FileArray}(
  x,
  baseline_windows,
  method = c("percentage", "sqrt_percentage", "decibel", "zscore", "sqrt_zscore"),
  units = c("Frequency", "Trial", "Electrode"),
  filebase = NULL,
  ...
)

\method{power_baseline}{array}(
  x,
  baseline_windows,
  method = c("percentage", "sqrt_percentage", "decibel", "zscore", "sqrt_zscore"),
  units = c("Trial", "Frequency", "Electrode"),
  ...
)
}
\arguments{
\item{x}{R array, \code{\link[filearray]{filearray}}, or
\code{'rave_prepare_power'} object created by
\code{\link{prepare_subject_power_with_epochs}}.}

\item{baseline_windows}{list of baseline window (intervals)}

\item{method}{baseline method; choices are \code{'percentage'},
\code{'sqrt_percentage'}, \code{'decibel'}, \code{'zscore'},
\code{'sqrt_zscore'}; see 'Details' in \code{\link[ravetools]{baseline_array}}}

\item{units}{the unit of the baseline; see 'Details'}

\item{...}{passed to other methods}

\item{electrodes}{the electrodes to be included in baseline calculation;
for power repository object produced by
\code{\link{prepare_subject_power_with_epochs}} only; default is all
available electrodes}

\item{filebase}{where to store the output; default is \code{NULL} and is
automatically determined}
}
\value{
Usually the same type as the input: for arrays
and \code{\link[filearray]{filearray}}, the outputs are
also the same type with the same dimensions; for \code{'rave_prepare_power'}
repositories, the results will be stored in its \code{'baselined'} element;
see 'Examples'.
}
\description{
Calculate power baseline
}
\details{
The arrays must be four-mode tensor and must have valid named
\code{\link{dimnames}}. The dimension names must be \code{'Trial'},
\code{'Frequency'}, \code{'Time'}, \code{'Electrode'}, case sensitive.

The \code{baseline_windows} determines the baseline windows that are used to
calculate time-points of baseline to be included. This can be one
or more intervals and must pass the validation function
\code{\link{validate_time_window}}.

The \code{units} determines the unit of the baseline. It can be one or
more of \code{'Trial'}, \code{'Frequency'}, \code{'Electrode'}. The default
value is all of them, i.e., baseline for each combination of trial,
frequency, and electrode. To share the baseline across trials, please
remove \code{'Trial'} from \code{units}. To calculate baseline that should
be shared across electrodes (e.g. in some mini-electrodes), remove
\code{'Electrode'} from the \code{units}.
}
\examples{

if( has_rave_subject("demo/DemoSubject") ) {

# The following code need to download additional demo data
# Please see https://rave.wiki/ for more details

repo <- prepare_subject_power_with_epochs(
  subject = "demo/DemoSubject",
  time_windows = c(-1, 3),
  electrodes = c(14, 15))

##### Direct baseline on the repository
power_baseline(x = repo, method = "decibel",
               baseline_windows = list(c(-1, 0), c(2, 3)))
power_mean <- repo$power$baselined$collapse(
  keep = c(2,1), method = "mean")
image(power_mean, x = repo$time_points, y = repo$frequency,
      xlab = "Time (s)", ylab = "Frequency (Hz)",
      main = "Mean power over trial (Baseline: -1~0 & 2~3)")
abline(v = 0, lty = 2, col = 'blue')
text(x = 0, y = 20, "Aud-Onset", col = "blue", cex = 0.6)

##### Alternatively, baseline on electrode instances
baselined <- lapply(repo$power$data_list, function(inst) {
  re <- power_baseline(inst, method = "decibel",
                       baseline_windows = list(c(-1, 0), c(2, 3)))
  collapse2(re, keep = c(2,1), method = "mean")
})
power_mean2 <- (baselined[[1]] + baselined[[2]]) / 2

# Same with precision difference
max(abs(power_mean2 - power_mean)) < 1e-6


}

}
