% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoSurvSampleSizeNI.R
\name{twoSurvSampleSizeNI}
\alias{twoSurvSampleSizeNI}
\title{Sample Size Calculation for Two-Group Non-Inferiority Survival Study}
\usage{
twoSurvSampleSizeNI(
  syear,
  yrsurv1,
  yrsurv2,
  alloc,
  accrualTime,
  followTime,
  alpha,
  power,
  margin
)
}
\arguments{
\item{syear}{Survival time horizon (e.g., median survival time) in years.}

\item{yrsurv1}{Survival probability of the standard group at \code{syear}.}

\item{yrsurv2}{Survival probability of the test group at \code{syear}.}

\item{alloc}{Allocation ratio (Test / Standard), e.g., 1 means equal allocation.}

\item{accrualTime}{Duration of patient accrual period.}

\item{followTime}{Follow-up period after last patient is accrued.}

\item{alpha}{One-sided significance level (e.g., 0.025).}

\item{power}{Desired statistical power (e.g., 0.8).}

\item{margin}{Non-inferiority margin for hazard ratio (HR).}
}
\value{
A list containing:
\describe{
\item{Sample_size_of_standard_group}{Required sample size in the standard group.}
\item{Sample_size_of_test_group}{Required sample size in the test group.}
\item{Total_sample_size}{Total sample size.}
\item{Expected_event_numbers_of_standard_group}{Expected number of events in the standard group.}
\item{Expected_event_numbers_of_test_group}{Expected number of events in the test group.}
\item{Total_expected_event_numbers}{Total number of expected events across both groups.}
}
}
\description{
Calculates the required sample size and expected event numbers for a non-inferiority trial with two survival curves,
using piecewise integration of hazard functions under exponential survival assumptions.
}
\examples{
twoSurvSampleSizeNI(
  syear = 2,
  yrsurv1 = 0.7,
  yrsurv2 = 0.65,
  alloc = 1,
  accrualTime = 1,
  followTime = 1,
  alpha = 0.025,
  power = 0.8,
  margin = 1.3
)

}
\references{
Jung SH, Chow SC. (2012). On sample size calculation for comparing survival curves under general hypothesis testing.
\emph{Journal of Biopharmaceutical Statistics}, 22(3), 485–495.

Web calculator (Non-Inferiority):
https://nshi.jp/en/js/twosurvyrni/
}
