% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{repmat}
\alias{repmat}
\title{Repeat Vectors and Matrices}
\usage{
repmat(x, m, n)
}
\arguments{
\item{x}{A \link{vector} or \link{matrix}.}

\item{m}{Integer specifying how many times to repeat \code{x} in the first
dimension.}

\item{n}{Integer specifying how many times to repeat \code{x} in the second
dimension.}
}
\value{
A block matrix of dimension \code{m*nrow(x)} by \code{n*ncol(x)}.
}
\description{
Repeat a vector or matrix a specific number of times.
}
\examples{
repmat(1:3, 3, 2) # will have dimension 9 by 2
repmat(randn(2, 2), 3, 2)
}
