% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tephra3D.R
\name{BlastAnim3d}
\alias{BlastAnim3d}
\title{Tephra Transport Snapshots}
\usage{
BlastAnim3d(L, tframe = 0.1, dir = ".", TOPO = NULL, az = 0,
  xlim = NULL, ylim = NULL, zlim = NULL, units = "m",
  plotMapView = TRUE, plotCrossSection = TRUE)
}
\arguments{
\item{L}{output of BlastSim3d}

\item{tframe}{time interval between frames [s]}

\item{dir}{directory where png files should be saved}

\item{TOPO}{DEM: list containing vectors x and y and matrix z with dimensions (length(x), length(y))}

\item{az}{azimuth of section line (degrees clockwise from North)}

\item{xlim}{easting limits for map view}

\item{ylim}{northing limits for map view}

\item{zlim}{elevation limits for section view}

\item{units}{units of length (string)}

\item{plotMapView}{logical: should the map view panel be plotted?}

\item{plotCrossSection}{logical: should the cross-section panel be plotted?}
}
\description{
Generates png files showing map view and cross-section view of tephra motion and final position on ground
}
\examples{
## Not run:
## BlastSim3d(v = 40, th_i = 2* 1:40, th_a = 90, dt = 0.01)
## BlastAnim3d(L, tframe = 0.1, az = 90)
## ImageMagick shell command: animate -delay 10 * # animate with 0.1-s frame rate
}
\keyword{misc}
