% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athl_fun.R
\name{athl_fun}
\alias{athl_fun}
\title{Get data for an athlete}
\usage{
athl_fun(athl_num, trace = TRUE)
}
\arguments{
\item{athl_num}{numeric vector of athlete id(s) used by Strava, as character string}

\item{trace}{logical indicating if output is returned to console}
}
\value{
A list for each athlete, where each element is an additional list with elements for the athlete's information.  The list elements are named using the athlete id numbers.
}
\description{
Get data for an athlete by web scraping, does not require authentication.
}
\details{
The athlete id is assigned to the user during registration with Strava and this must be known to use the function.  Some users may have privacy settings that prevent public access to account information (a message indicating as such will be returned by the function). The function scrapes data using the following URL with the appended athlete id, e.g., \url{https://www.strava.com/athletes/2837007}.  Opening the URL in a web browser can verify if the data can be scraped.  Logging in to the Strava account on the website may also be required before using this function.
}
\examples{
## single athlete
athl_fun('2837007')

## multiple athletes
athl_fun(c('2837007', '2527465'))
}
\concept{notoken}
