% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estThermo.R
\name{estThermo}
\alias{estThermo}
\title{Estimate Average Thermocline Depth}
\usage{
estThermo(data, site, date, depth, temp, combine = "all")
}
\arguments{
\item{data}{data frame of water column temperature profiles}

\item{site}{character giving the name of the site column}

\item{date}{character giving the name of the date column}

\item{depth}{character giving the name of the depth column}

\item{temp}{character giving the name of the temp column}

\item{combine}{logical indicating whether or not to average across sites ("sites"), dates ("dates"), or sites and dates ("all"), default = "all"}
}
\value{
either numeric value of average thermocline depth, standard deviation, and n or data frame of thermocline depths, standard deviations, and n across sites or dates
}
\description{
Estimate average thermocline depth across multiple sites and dates.
}
\examples{
# load test profile data
data <-  read.csv(system.file("extdata", "example_profile_data.csv", package = 'rLakeHabitat'))
data$date <- base::as.Date(data$date)
#run function
estThermo(data = data, site = "site", date = "date",
depth = "depth", temp = "temp", combine = "all")
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
