% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcHyps.R
\name{calcHyps}
\alias{calcHyps}
\title{Calculate Hypsography}
\usage{
calcHyps(DEM, DEMunits = "m", depthUnits = "ft", by = 1, output = "values")
}
\arguments{
\item{DEM}{SpatRaster object of a given waterbody, rasters can be transformed to SpatRaster via the rast() function in 'terra'}

\item{DEMunits}{character describing units of raster coordinate system. Can be meters, kilometers, or hectares ("m", "km", "ha"), default = "m"}

\item{depthUnits}{character describing units of depth measurement. Can be either feet or meters ("ft", "m"), default = "ft"}

\item{by}{numeric increment per unit by which volumes are calculated. Higher values will result in lower resolution. Default = 1}

\item{output}{character describing desired output, can either be a data frame of values ("values") or a hypsography plot ("plot"). Default = "values"}
}
\value{
data frame of areas at each depth unit ("values") or a hypsography plot ("plot")
}
\description{
Calculates area at each depth for a given waterbody.
}
\examples{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
#run function
calcHyps(DEM, DEMunits = 'm', depthUnits = 'm', by = 1, output = 'values')
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
