% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/java_unpack.R
\name{java_unpack}
\alias{java_unpack}
\title{Unpack a Java distribution file into cache directory}
\usage{
java_unpack(java_distrib_path, quiet = FALSE)
}
\arguments{
\item{java_distrib_path}{A \code{character} vector of length 1 containing the path to the Java distribution file.}

\item{quiet}{A \code{logical} value indicating whether to suppress messages. Can be \code{TRUE} or \code{FALSE}.}
}
\value{
A \code{character} vector containing of length 1 containing the path to the unpacked Java directory.
}
\description{
Unpack the Java distribution file into cache directory and return the path to the unpacked Java directory with Java binaries.
}
\examples{
\dontrun{

# set cache dir to temporary directory
options(rJavaEnv.cache_path = tempdir())

# download Java 17 distrib and unpack it into cache dir
java_17_distrib <- java_download(version = "17")
java_home <- java_unpack(java_distrib_path = java_17_distrib)

# set the JAVA_HOME environment variable in the current session
# to the cache dir without touching any files in the current project directory
java_env_set(where = "session", java_home = java_home)
}

}
