% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decodePM.R
\name{decodePM}
\alias{decodePM}
\title{Implement \code{DECODE} for simple precision matrix estimation}
\usage{
decodePM(X, lambda0 = NULL, ...)
}
\arguments{
\item{X}{\eqn{n\times p}{nxp} data matrix.}

\item{lambda0}{number between 0 and 1. If \code{NULL}, will use \eqn{\sqrt{2 \log{p}/n}}{\sqrt2logp/n}.}

\item{...}{additional arguments to be passed to general decode function.}
}
\value{
An object of class \code{decodePM} containing:
  \item{Omega}{\code{DECODE} of \eqn{\Omega}.}
  \item{lambda0}{the \code{lambda0} used.}
  \item{X}{data used.}
  \item{theta}{final \eqn{\theta} for each column.}
  \item{lambda}{final \eqn{\lambda} for each column.}
  \item{total.iter}{number of iterations until convergence for each column.}
}
\description{
Implement \code{DECODE} to estimate a precision matrix of \code{X}. This implementation is used in Hadimaja and Pun (2018).
}
\examples{
# estimate the precision matrix of iris data
object <- decodePM(iris[,1:4], lambda0 = 0.01)

object
summary(object)

object$Omega

}
\references{
Hadimaja, M. Z., & Pun, C. S. (2018). A Self-Calibrated Regularized Direct Estimation for Graphical Selection and Discriminant Analysis.
}
