% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_get_convert_trade}
\alias{cb_get_convert_trade}
\title{Get Convert Trade}
\usage{
cb_get_convert_trade(trade_id, from_account, to_account)
}
\arguments{
\item{trade_id}{= The ID of the trade to commit.}

\item{from_account}{= The currency of the account to convert from (e.g. USD).}

\item{to_account}{= The currency of the account to convert to (e.g. USDC).}
}
\value{
A \code{data.frame} with account information about a convert trade with a specified trade id, source account, and target account
}
\description{
Get Convert Trade
}
\examples{
\dontrun{
  qte = cb_create_convert_quote(amount = 100,
                                from_account = "USD",
                                to_account = "USDC")
  ord = cb_commit_convert_trade(trade_id = qte$id,
                                from_account = "USD",
                                to_account = "USDC")
 stat = cb_get_convert_trade(trade_id = qte$id,
                             from_account = "USD",
                             to_account = "USDC")
}
}
