% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_process.R
\name{get.miss}
\alias{get.miss}
\title{Get missingness of individuals in raw vcf}
\usage{
get.miss(
  data,
  type = c("samples", "snps"),
  plot = TRUE,
  verbose = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{data}{a list containing imported vcf file using \code{readVCF} or
genotype table generated using \code{hetTgen}}

\item{type}{character.  Missing percentages per sample
\dQuote{samples} or per SNP \dQuote{snps}, default both}

\item{plot}{logical. Whether to plot the missingness density with ninety
five percent quantile}

\item{verbose}{logical. Whether to show progress}

\item{parallel}{logical. whether to parallelize the process}
}
\value{
Returns a data frame of allele depth or genotypes
}
\description{
A function to get the percentage of missing data of snps per SNP and per
sample
}
\examples{
\dontrun{vcf.file.path <- paste0(path.package("rCNV"), "/example.raw.vcf.gz")
vcf <- readVCF(vcf.file.path=vcf.file.path)
missing<-get.miss(vcf,plot=TRUE)}

}
\author{
Piyal Karunarathne
}
