% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{wirePlot}
\alias{wirePlot}
\title{wirePlot: 3D Plot}
\usage{
wirePlot(
  x,
  y,
  z,
  data = NULL,
  xlim,
  ylim,
  zlim,
  main,
  xlab,
  ylab,
  sub,
  sub.a = TRUE,
  zlab,
  form = "fit",
  col = "Rainbow",
  steps,
  fun,
  plot = TRUE,
  show.scale = TRUE,
  n.scene = "scene"
)
}
\arguments{
\item{x}{Name providing the Factor A for the plot.}

\item{y}{Name providing the Factor B for the plot.}

\item{z}{Name giving the Response variable.}

\item{data}{Needs to be an object of class \code{facDesign} and contains the names of \code{x}, \code{y}, \code{z}.}

\item{xlim}{Numeric vector of length 2: limits for the x-axis. If missing, limits are set automatically.}

\item{ylim}{Numeric vector of length 2: limits for the y-axis. If missing, limits are set automatically.}

\item{zlim}{Numeric vector of length 2: limits for the z-axis. If missing, limits are set automatically.}

\item{main}{Character string: title of the plot.}

\item{xlab}{Character string: label for the x-axis.}

\item{ylab}{Character string: label for the y-axis.}

\item{sub}{Character string: subtitle for the plot. Default is \code{NULL}.}

\item{sub.a}{Logical value indicating whether to display the subtitle. Default is \code{TRUE}.}

\item{zlab}{Character string: label for the z-axis.}

\item{form}{Character string specifying the form of the surface to be plotted. Options include
\itemize{
    \item \code{`quadratic`}
    \item \code{`full`}
    \item \code{`interaction`}
    \item \code{`linear`}
    \item \code{`fit`}
    }
Default is \code{`fit`}.}

\item{col}{Character string specifying the color palette to use for the plot (e.g., \code{`Rainbow`}, \code{`Jet`}, \code{`Earth`}, \code{`Electric`}). Default is \code{`Rainbow`}.}

\item{steps}{Numeric value specifying the number of steps for the grid in the plot. Higher values result in a smoother surface.}

\item{fun}{Optional function to be applied to the data before plotting.}

\item{plot}{Logical value indicating whether to display the plot. Default is \code{TRUE}.}

\item{show.scale}{Logical value indicating whether to display the color scale on the plot. Default is \code{TRUE}.}

\item{n.scene}{Character string specifying the scene name for the plot. Default is \code{`scene`}.}
}
\value{
The function \code{wirePlot} returns an invisible list containing:
\item{plot}{The generated wireframe plot.}
\item{grid}{The grid data used for plotting.}
}
\description{
Creates a wireframe diagram for an object of class \code{\link{facDesign.c}}.
}
\details{
The \code{wirePlot} function is used to create a 3D wireframe plot that visualizes the relationship between two factors and a response variable. The plot can be customized in various ways, including changing axis labels, adding subtitles, and choosing the color palette.
}
\examples{
# Example 1: Basic wireframe plot
x <- seq(-10, 10, length = 30)
y <- seq(-10, 10, length = 30)
z <- outer(x, y, function(a, b) sin(sqrt(a^2 + b^2)))
wirePlot(x, y, z, main = "3D Wireframe Plot", xlab = "X-Axis", ylab = "Y-Axis", zlab = "Z-Axis")

fdo = rsmDesign(k = 3, blocks = 2)
fdo$.response(data.frame(y = rnorm(fdo$nrow())))

#I - display linear fit
wirePlot(A,B,y, data = fdo, form = "linear")

#II - display full fit (i.e. effect, interactions and quadratic effects
wirePlot(A,B,y, data = fdo, form = "full")

#III - display a fit specified before
fdo$set.fits(fdo$lm(y ~ B + I(A^2)))
wirePlot(A,B,y, data = fdo, form = "fit")

#IV - display a fit given directly
wirePlot(A,B,y, data = fdo, form = "y ~ A*B + I(A^2)")

#V - display a fit using a different colorRamp
wirePlot(A,B,y, data = fdo, form = "full", col = 2)

}
\seealso{
\code{\link{contourPlot}}, \code{\link{paretoChart}}.
}
