% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.3_Taguchi_designs_Functions.R
\name{taguchiChoose}
\alias{taguchiChoose}
\title{taguchiChoose: Taguchi Designs}
\usage{
taguchiChoose(
  factors1 = 0,
  factors2 = 0,
  level1 = 0,
  level2 = 0,
  ia = 0,
  col = 2,
  randomize = TRUE,
  replicates = 1
)
}
\arguments{
\item{factors1}{Integer number of factors on level1. By default set to `0`.}

\item{factors2}{Integer number of factors on level2. By default set to `0`.}

\item{level1}{Integer number of levels on level1. By default set to `0`.}

\item{level2}{Integer number of levels on level2. By default set to `0`.}

\item{ia}{Integer number of interactions. By default set to `0`.}

\item{col}{Select the color scheme for the selection matrix: use \code{1} for blue, \code{2} for pink (default), and \code{3} for a variety of colors.}

\item{randomize}{A logical value (\code{TRUE}/\code{FALSE}) that specifies whether to randomize the RunOrder of the design.
By default, \code{randomize} is set to \code{TRUE}.}

\item{replicates}{An integer specifying the number of replicates for each run in the design.}
}
\value{
\code{taguchiChoose} returns an object of class \code{taguchiDesign}.
}
\description{
Shows a matrix of possible taguchi designs
}
\details{
\code{taguchiChoose} returns possible taguchi designs.
Specifying the number of factor1 factors with level1 levels (factors1 = 2, level1 = 3 means 2 factors with 3 factor levels) and factor2 factors with level2 levels and desired interactions one or more taguchi designs are suggested.
If all parameters are set to 0, a matrix of possible taguchi designs is shown.
}
\examples{
tdo1 <- taguchiChoose()
tdo1 <- taguchiChoose(factors1 = 3, level1 = 2)
}
\seealso{
\itemize{
\item{\code{\link{facDesign}}: for 2^k factorial designs.}
\item{\code{\link{rsmDesign}}: for response surface designs.}
\item{\code{\link{fracDesign}}: for fractional factorial design.}
\item{\code{\link{gageRRDesign}}: for gage designs.}
}
}
