% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_Factorial_designs_Classes.R
\name{steepAscent.c}
\alias{steepAscent.c}
\title{steepAscent-class: Class `steepAscent`}
\description{
The \code{steepAscent.c} class represents a steepest ascent algorithm in a factorial design context. This class is used for optimizing designs based on iterative improvements.
}
\seealso{
\code{\link{steepAscent}}, \code{\link{desirability.c}}, \code{\link{optimum}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{A character string representing the name of the steep ascent design.}

\item{\code{X}}{A data frame containing the design matrix for the steepest ascent procedure. This matrix represents the factors and their levels at each iteration.}

\item{\code{response}}{A data frame containing the response values associated with the design matrix.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-steepAscent,c-.response}{\code{steepAscent.c$.response()}}
\item \href{#method-steepAscent,c-get}{\code{steepAscent.c$get()}}
\item \href{#method-steepAscent,c-as.data.frame}{\code{steepAscent.c$as.data.frame()}}
\item \href{#method-steepAscent,c-print}{\code{steepAscent.c$print()}}
\item \href{#method-steepAscent,c-plot}{\code{steepAscent.c$plot()}}
\item \href{#method-steepAscent,c-clone}{\code{steepAscent.c$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-steepAscent,c-.response"></a>}}
\if{latex}{\out{\hypertarget{method-steepAscent,c-.response}{}}}
\subsection{Method \code{.response()}}{
Get and set the `response` values in an object of class `steepAscent.c`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{steepAscent.c$.response(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A data frame or numeric vector to set as the new `response`. If missing, returns the current `response`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-steepAscent,c-get"></a>}}
\if{latex}{\out{\hypertarget{method-steepAscent,c-get}{}}}
\subsection{Method \code{get()}}{
Access specific elements in the design matrix or response data of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{steepAscent.c$get(i, j)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{An integer specifying the row index to retrieve.}

\item{\code{j}}{An integer specifying the column index to retrieve.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-steepAscent,c-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-steepAscent,c-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Convert the object to a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{steepAscent.c$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-steepAscent,c-print"></a>}}
\if{latex}{\out{\hypertarget{method-steepAscent,c-print}{}}}
\subsection{Method \code{print()}}{
Print the details of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{steepAscent.c$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-steepAscent,c-plot"></a>}}
\if{latex}{\out{\hypertarget{method-steepAscent,c-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the results of the steepest ascent procedure for an object of class `steepAscent.c`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{steepAscent.c$plot(main, xlab, ylab, l.col, p.col, line.type, point.shape)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{main}}{The main title of the plot.}

\item{\code{xlab}}{The label for the x-axis.}

\item{\code{ylab}}{The label for the y-axis.}

\item{\code{l.col}}{Color for the line in the plot.}

\item{\code{p.col}}{Color for the points in the plot.}

\item{\code{line.type}}{Type of the line used in the plot.}

\item{\code{point.shape}}{Shape of the points used in the plot.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-steepAscent,c-clone"></a>}}
\if{latex}{\out{\hypertarget{method-steepAscent,c-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{steepAscent.c$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
