% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_dpq_distributions_adSim.R
\name{pweibull3}
\alias{pweibull3}
\title{pweibull3: The Weibull Distribution (3 Parameter)}
\usage{
pweibull3(q, shape, scale, threshold)
}
\arguments{
\item{q}{A numeric vector of quantiles.}

\item{shape}{The shape parameter of the Weibull distribution. Default is 1.}

\item{scale}{The scale parameter of the Weibull distribution. Default is 1.}

\item{threshold}{The threshold (or location) parameter of the Weibull distribution. Default is 0.}
}
\value{
\code{dweibull3} returns the density, \code{pweibull3} returns the distribution function, and \code{qweibull3} returns the quantile function for the Weibull distribution with a threshold.
}
\description{
Density function, distribution function, and quantile function for the Weibull distribution with a threshold parameter.
}
\details{
The Weibull distribution with the \code{scale} parameter alpha, \code{shape} parameter c, and \code{threshold} parameter zeta has a density function given by:
\deqn{f(x) = \frac{c}{\alpha} \left(\frac{x - \zeta}{\alpha}\right)^{c-1} \exp\left(-\left(\frac{x - \zeta}{\alpha}\right)^c\right)}

The cumulative distribution function is given by:
\deqn{F(x) = 1 - \exp\left(-\left(\frac{x - \zeta}{\alpha}\right)^c\right)}
}
\examples{
dweibull3(x = 1, scale = 1, shape = 5, threshold = 0)
temp <- pweibull3(q = 1, scale = 1, shape = 5, threshold = 0)
temp
qweibull3(p = temp, scale = 1, shape = 5, threshold = 0)
}
