% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3_Distr_DistrCollection_Functions.R
\name{distribution}
\alias{distribution}
\title{distribution: Distribution}
\usage{
distribution(x = NULL, distrib = "weibull", ...)
}
\arguments{
\item{x}{Vector of distributed values from which the parameter should be determined.}

\item{distrib}{Character string specifying the distribution of x. The function \code{distribution} will accept the following character strings for \code{distribution}:
\itemize{
  \item{\code{`normal`}}
  \item{\code{`chi-squared`}}
  \item{\code{`exponential`}}
  \item{\code{`logistic`}}
  \item{\code{`gamma`}}
  \item{\code{`weibull`}}
  \item{\code{`cauchy`}}
  \item{\code{`beta`}}
  \item{\code{`f`}}
  \item{\code{`t`}}
  \item{\code{`geometric`}}
  \item{\code{`poisson`}}
  \item{\code{`negative binomial`}}
  \item{\code{`log-normal`}}
}
By default, \code{distribution} is set to \code{`weibull`}.}

\item{...}{Additional arguments to be passed to the fitting function.}
}
\value{
\code{distribution()} returns an object of class \code{DistrCollection}.
}
\description{
Calculates the most likely parameters for a given distribution.
}
\examples{
data1 <- rnorm(100, mean = 5, sd = 2)
distribution(data1, distrib = "normal")
}
\seealso{
\code{\link{Distr}}, \code{\link{DistrCollection}}
}
