% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_dpq_distributions_adSim.R
\name{dgamma3}
\alias{dgamma3}
\title{dgamma3: The gamma Distribution (3 Parameter)}
\usage{
dgamma3(x, shape, scale, threshold)
}
\arguments{
\item{x}{A numeric vector of quantiles.}

\item{shape}{The shape parameter, default is \code{1}.}

\item{scale}{The scale parameter, default is \code{1}.}

\item{threshold}{The threshold parameter, default is \code{0}.}
}
\value{
\code{dgamma3} gives the density, \code{pgamma3} gives the distribution function, and \code{qgamma3} gives the quantile function.
}
\description{
Density function, distribution function, and quantile function for the Gamma distribution.
}
\details{
The Gamma distribution with \code{scale} parameter alpha, \code{shape} parameter c, and \code{threshold} parameter zeta has a density given by:

\deqn{f(x) = \frac{c}{\alpha}\left(\frac{x-\zeta}{\alpha}\right)^{c-1}\exp\left(-\left(\frac{x-\zeta}{\alpha}\right)^c\right)}

The cumulative distribution function is given by:

\deqn{F(x) = 1 - \exp\left(-\left(\frac{x-\zeta}{\alpha}\right)^c\right)}
}
\examples{
dgamma3(x = 1, scale = 1, shape = 5, threshold = 0)
temp <- pgamma3(q = 1, scale = 1, shape = 5, threshold = 0)
temp
qgamma3(p = temp, scale = 1, shape = 5, threshold = 0)
}
