% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{blocking}
\alias{blocking}
\title{blocking: Blocking}
\usage{
blocking(fdo, blocks, random.seed, useTable = "rsm", gen)
}
\arguments{
\item{fdo}{An object of class \code{\link{facDesign.c}}.}

\item{blocks}{Numeric value giving the number of blocks.}

\item{random.seed}{Numeric value to generate repeatable results for randomization within blocks.}

\item{useTable}{Character indicating which table to use. The following options will be accepted:
\itemize{
   \item \code{`rms`}: table from reference
   \item \code{`calc`}: table calculated by package
}}

\item{gen}{Giving the generator that will be used.}
}
\value{
The function \code{blocking} returns an object of class \code{\link{facDesign.c}} with blocking structure.
}
\description{
Blocks a given factorial or response surface design.
}
\examples{
# Example 1
#Create a 2^3 full factorial design
fdo <- facDesign(k = 3)
# Apply blocking to the design with 2 blocks
blocking(fdo, 2)

# Example 2
#Create a response surface design for 3 factors
fdo <- rsmDesign(k = 3)
# Apply blocking to the design with 3 blocks (1 block for star part and 2 blocks for the cube part)
blocking(fdo, 3)
}
\seealso{
\code{\link{facDesign}}.
}
