% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_p21.R
\name{p21_to_evidence}
\alias{p21_to_evidence}
\title{Parse Pinnacle21 Output to Evidence}
\usage{
p21_to_evidence(
  p21_df,
  ctx,
  asset_type = "validation",
  source_version = NULL,
  default_domain = "quality"
)
}
\arguments{
\item{p21_df}{A data.frame containing Pinnacle21 validation output. Expected
columns (case-insensitive): \code{Rule} (or \verb{Rule ID}), \code{Message}, \code{Severity},
\code{Dataset}, \code{Variable}, \code{Result} (or \code{Status}).}

\item{ctx}{A \link{r4sub_run_context} providing run and study metadata.}

\item{asset_type}{Character. Asset type label. Default: \code{"validation"}.}

\item{source_version}{Character or \code{NULL}. Version of the P21 tool.}

\item{default_domain}{Character. Indicator domain. Default: \code{"quality"}.}
}
\value{
A data.frame conforming to the evidence schema.
}
\description{
Converts a data.frame of Pinnacle21-style validation results into the
standard evidence table format. Column names are detected case-insensitively.
}
\examples{
p21_raw <- data.frame(
  Rule = c("SD0001", "SD0002"),
  Message = c("Missing variable label", "Invalid format"),
  Severity = c("Error", "Warning"),
  Dataset = c("ADSL", "ADAE"),
  Variable = c("AGE", "AESTDTC"),
  Status = c("Failed", "Warning"),
  stringsAsFactors = FALSE
)
ctx <- r4sub_run_context("STUDY1", "DEV")
ev <- p21_to_evidence(p21_raw, ctx)

}
