% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.R
\name{logit_model}
\alias{logit_model}
\title{Train a Regularized Logistic Regression Model using glmnet}
\usage{
logit_model(
  train_vectorized,
  Y,
  test_vectorized,
  parallel = FALSE,
  tune = FALSE
)
}
\arguments{
\item{train_vectorized}{The training feature matrix (e.g., a `dfm` from quanteda).
This should be a sparse matrix.}

\item{Y}{The response variable for the training set. Should be a factor for
classification.}

\item{test_vectorized}{The test feature matrix, which must have the same
features as `train_vectorized`.}

\item{parallel}{Logical}

\item{tune}{Logical}
}
\value{
A list containing two elements:
  \item{pred}{A vector of class predictions for the test set.}
  \item{probs}{A matrix of predicted probabilities.}
  \item{model}{The final, trained `cv.glmnet` model object.}
  \item{best_lambda}{The optimal lambda value found during cross-validation.}
}
\description{
This function trains a logistic regression model using Lasso regularization
via the glmnet package. It uses cross-validation to automatically find the
optimal regularization strength (lambda).
}
\examples{
\dontrun{
# Create dummy vectorized training and test data
train_matrix <- matrix(runif(100), nrow = 10, ncol = 10)
test_matrix <- matrix(runif(50), nrow = 5, ncol = 10)

# Provide column names (vocabulary) required by glmnet
colnames(train_matrix) <- paste0("word", 1:10)
colnames(test_matrix) <- paste0("word", 1:10)

y_train <- factor(sample(c("P", "N"), 10, replace = TRUE))

# Run logistic regression model (glmnet)
model_results <- logit_model(train_matrix, y_train, test_matrix)
}
}
