% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluate_metrics}
\alias{evaluate_metrics}
\title{Calculate Classification Metrics}
\usage{
evaluate_metrics(predicted, actual)
}
\arguments{
\item{predicted}{A factor vector of predicted classes.}

\item{actual}{A factor vector of actual true classes.}
}
\value{
A list object containing the following metrics:
  \item{confusion_matrix}{A base R `table` object representing the cross-tabulation of predictions vs. actuals.}
  \item{accuracy}{Numeric. The overall accuracy of the model.}
  \item{precision}{Numeric. (Binary only) The Positive Predictive Value.}
  \item{recall}{Numeric. (Binary only) The True Positive Rate (Sensitivity).}
  \item{specificity}{Numeric. (Binary only) The True Negative Rate.}
  \item{f1_score}{Numeric. (Binary only) The harmonic mean of precision and recall.}
}
\description{
A lightweight, dependency-free alternative to caret::confusionMatrix.
Calculates accuracy, and for binary classification, adds precision, 
recall, and F1 score.
}
